/**
 * @license
 * Copyright 2023 Google Inc.
 * SPDX-License-Identifier: Apache-2.0
 */
import type { CDPSession } from '../api/CDPSession.js';
import type { ElementHandle } from '../api/ElementHandle.js';
import { Frame, type GoToOptions, type WaitForOptions } from '../api/Frame.js';
import type { WaitForSelectorOptions } from '../api/Page.js';
import type { TimeoutSettings } from '../common/TimeoutSettings.js';
import type { Awaitable, NodeFor } from '../common/types.js';
import { BidiCdpSession } from './CDPSession.js';
import type { BrowsingContext } from './core/BrowsingContext.js';
import type { BidiHTTPResponse } from './HTTPResponse.js';
import type { BidiPage } from './Page.js';
import type { BidiRealm } from './Realm.js';
import { BidiFrameRealm } from './Realm.js';
export declare class BidiFrame extends Frame {
    #private;
    static from(parent: BidiPage | BidiFrame, browsingContext: BrowsingContext): BidiFrame;
    readonly browsingContext: BrowsingContext;
    readonly realms: {
        default: BidiFrameRealm;
        internal: BidiFrameRealm;
    };
    readonly _id: string;
    readonly client: BidiCdpSession;
    private constructor();
    get timeoutSettings(): TimeoutSettings;
    mainRealm(): BidiRealm;
    isolatedRealm(): BidiRealm;
    page(): BidiPage;
    isOOPFrame(): never;
    url(): string;
    parentFrame(): BidiFrame | null;
    childFrames(): BidiFrame[];
    goto(url: string, options?: GoToOptions): Promise<BidiHTTPResponse | null>;
    setContent(html: string, options?: WaitForOptions): Promise<void>;
    waitForNavigation(options?: WaitForOptions): Promise<BidiHTTPResponse | null>;
    waitForDevicePrompt(): never;
    get detached(): boolean;
    exposeFunction<Args extends unknown[], Ret>(name: string, apply: (...args: Args) => Awaitable<Ret>): Promise<void>;
    waitForSelector<Selector extends string>(selector: Selector, options?: WaitForSelectorOptions): Promise<ElementHandle<NodeFor<Selector>> | null>;
    createCDPSession(): Promise<CDPSession>;
}
//# sourceMappingURL=Frame.d.ts.map